<!DOCTYPE html>
<html>

<head>
    <title>Delete Account</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            background-color: #f3f4f6;
        }

        .container {
            background: white;
            padding: 2rem;
            border-radius: 0.5rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
            box-sizing: border-box;
            margin: 1rem;
        }

        h1 {
            text-align: center;
            color: #1f2937;
            margin-top: 0;
        }

        form div {
            margin-bottom: 1.5rem;
        }

        label {
            display: block;
            margin-bottom: 0.5rem;
            color: #4b5563;
            font-weight: 500;
        }

        input {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #d1d5db;
            border-radius: 0.375rem;
            box-sizing: border-box;
            transition: border-color 0.2s;
        }

        input:focus {
            outline: none;
            border-color: #3b82f6;
        }

        button {
            width: 100%;
            padding: 0.75rem;
            border: none;
            border-radius: 0.375rem;
            background-color: #ef4444;
            color: white;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.2s;
        }

        button:hover {
            background-color: #dc2626;
        }

        .error {
            color: #ef4444;
            background-color: #fee2e2;
            padding: 1rem;
            border-radius: 0.375rem;
            text-align: center;
            margin-bottom: 1rem;
        }

        .success {
            color: #16a34a;
            background-color: #dcfce7;
            padding: 1rem;
            border-radius: 0.375rem;
            text-align: center;
            margin-bottom: 1rem;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1>Delete Your Account</h1>

        <?php if(session('error')): ?>
        <p class="error"><?php echo e(session('error')); ?></p>
        <?php endif; ?>

        <?php if(session('success')): ?>
        <p class="success"><?php echo e(session('success')); ?></p>
        <?php endif; ?>

        <form action="<?php echo e(route('user.destroy')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>

            <div>
                <label for="login">Email or Phone:</label>
                <input type="text" id="login" name="login" required>
            </div>

            <div>
                <label for="password">Password:</label>
                <input type="password" id="password" name="password" required>
            </div>

            <div>
                <label for="password_confirmation">Confirm Password:</label>
                <input type="password" id="password_confirmation" name="password_confirmation" required>
            </div>

            <button type="submit">Delete Account</button>
        </form>
    </div>
</body>

</html><?php /**PATH C:\Users\nader\OneDrive\Desktop\FreeLance\Laravel\Momento\resources\views/users/delete.blade.php ENDPATH**/ ?>