<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\CityController;
use App\Http\Controllers\Api\NationalityController;
use App\Http\Controllers\Api\SettingController;

use App\Http\Controllers\Api\BannerController;

Route::get('/banners', [BannerController::class, 'index']);
Route::get('cities', [CityController::class, 'index']);
Route::get('nationalities', [NationalityController::class, 'index']);
Route::get('categories', [CategoryController::class, 'index']);
Route::get('settings', [SettingController::class, 'index']);


Route::group(['prefix' => 'user', 'namespace' => 'App\Http\Controllers\Api\User'], function () {
    // Account Management
    Route::post('register', 'UserAuthController@register');
    Route::post('login', 'UserAuthController@login');
    Route::post('password/forgot', 'UserAuthController@forgotPassword');
    Route::post('password/reset', 'UserAuthController@resetPassword');


    // Product Discovery
    Route::get('products', 'ProductController@index');
    Route::get('products/{product}', 'ProductController@show');
    Route::get('products/{product}/availabilities', 'ProductController@availabilities');
    Route::get('products/{product}/check-availability', 'ProductController@checkAvailability');
    Route::get('products/{product}/reviews', 'ProductController@reviews');


    Route::post('email/verify', 'UserAuthController@verifyEmail')->middleware(['auth:sanctum']);
    Route::post('email/send-verification', 'UserAuthController@sendEmailVerification')->middleware(['auth:sanctum']);

    Route::put('password/change', 'UserAuthController@changePassword')->middleware(['auth:sanctum']);

    Route::group(['middleware' => ['auth:sanctum', 'verified', \App\Http\Middleware\CheckIsActive::class]], function () {
        Route::get('profile', 'UserProfileController@show');
        Route::put('profile', 'UserProfileController@update');
        Route::delete('profile', 'UserProfileController@destroy');

        Route::post('password/send-verification-code', 'UserProfileController@sendVerificationCode');
        Route::post('profile/change-contact-details', 'UserProfileController@changeContactDetails');




        // Cart Management
        Route::get('cart', 'CartController@index');
        Route::post('cart', 'CartController@store');
        Route::delete('cart/{cartItem}', 'CartController@destroy');

        // Booking & Payment
        Route::get('bookings', 'BookingController@index');
        Route::post('bookings', 'BookingController@store');
        Route::get('bookings/{id}', 'BookingController@show')->name('user.bookings.show');
        Route::put('bookings/{id}', 'BookingController@update');
        Route::post('bookings/{id}/pay', 'BookingController@pay');
        Route::post('bookings/{id}/cancel', 'BookingController@cancel');

        // Favorites
        Route::get('favorites', 'FavoriteController@index');
        Route::post('favorites', 'FavoriteController@store');
        Route::delete('favorites/{id}', 'FavoriteController@destroy');

        // Reviews
        Route::post('reviews', 'ReviewController@store');

        // Notifications
        Route::get('notifications', 'NotificationController@index');
        Route::post('notifications/mark-all-as-read', 'NotificationController@markAllAsRead');
        Route::post('notifications/{id}/mark-as-read', 'NotificationController@markAsRead');
    });

    // Other Features
    Route::get('pages/{slug}', 'PageController@show');
    Route::post('contact', 'ContactController@store');
});
