<?php

namespace Database\Seeders;

use App\Models\Nationality;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class NationalitySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $nationalities = [
            ['name_en' => 'Saudi', 'name_ar' => 'سعودي'],
            ['name_en' => 'Egyptian', 'name_ar' => 'مصري'],
            ['name_en' => 'Emirati', 'name_ar' => 'إماراتي'],
            ['name_en' => 'Kuwaiti', 'name_ar' => 'كويتي'],
            ['name_en' => 'Qatari', 'name_ar' => 'قطري'],
        ];

        foreach ($nationalities as $nationality) {
            Nationality::create($nationality);
        }
    }
}
