<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('booking_items', function (Blueprint $table) {
            $table->foreignId('service_provider_id')->constrained()->cascadeOnDelete();
            $table->decimal('commission', 8, 2)->default(0);
            $table->decimal('net_price', 8, 2)->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('booking_items', function (Blueprint $table) {
            $table->dropForeign(['service_provider_id']);
            $table->dropColumn(['service_provider_id', 'commission', 'net_price']);
        });
    }
};
