<?php

namespace Database\Factories;

use App\Models\Category;
use App\Models\City;
use App\Models\Nationality;
use App\Models\ServiceProvider;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ServiceProvider>
 */
class ServiceProviderFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->name,
            'email' => $this->faker->unique()->safeEmail,
            'password' => Hash::make('password'),
            'phone' => $this->faker->phoneNumber,
            'nationality_id' => Nationality::factory(),
            'id_number' => $this->faker->numerify('##########'),
            'commercial_register_type' => 'freelance_document',
            'commercial_register_number' => $this->faker->numerify('##########'),
            'is_active' => $this->faker->boolean,
            'category_id' => Category::factory(), // Associate with a category
        ];
    }

    /**
     * Configure the model factory.
     *
     * @return $this
     */
    public function configure()
    {
        return $this->afterCreating(function (ServiceProvider $provider) {
            $cities = City::factory()->count(2)->create();
            $provider->cities()->attach($cities);
        });
    }
}
