<?php

namespace Database\Factories;

use App\Models\Booking;
use App\Models\BookingItem;
use App\Models\ServiceProvider;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Booking>
 */
class BookingFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'user_id' => User::factory(),
            'service_provider_id' => ServiceProvider::factory(),
            'status' => $this->faker->randomElement(['pending', 'confirmed', 'completed', 'canceled']),
            'booking_date' => $this->faker->dateTimeBetween('+1 day', '+1 month'),
            'total_amount' => $this->faker->randomFloat(2, 50, 500),
            'commission_amount' => $this->faker->randomFloat(2, 5, 50),
            'net_amount' => $this->faker->randomFloat(2, 45, 450),
            'payment_method' => 'cash',
            'payment_status' => 'pending',
        ];
    }

    /**
     * Configure the model factory.
     *
     * @return $this
     */
    public function configure()
    {
        return $this->afterCreating(function (Booking $booking) {
            BookingItem::factory()->create(['booking_id' => $booking->id]);
        });
    }
}
