<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'resend' => [
        'key' => env('RESEND_KEY'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],
    'taqnyat' => [
        'api_key' => env('SMS_TAQNYAT_API_KEY'),
        'sender_id' => env('SMS_TAQNYAT_SENDER_ID', 'Moment.w'),
        'base_url' => 'https://www.msegat.com/gw/', // MSEGAT API base URL
    ],

    'telr' => [
        'store_id' => env('TELR_STORE_ID'),
        'auth_key' => env('TELR_AUTH_KEY'),
        'test_mode' => env('TELR_TEST_MODE', true),
    ],

    'hyperpay' => [
        'base_url' => env('HYPER_PAY_MODE') == 'live' ? 'https://eu-prod.oppwa.com' : 'https://eu-test.oppwa.com',
        'access_token' => env('HYPER_PAY_ACCESS_TOKEN'),
        'entity_id' => env('HYPER_PAY_ENTITY_ID'),
        'payment_type' => env('HYPER_PAY_PaymentType', 'DB'),
        'currency' => env('HYPER_PAY_Currency', 'SAR'),
    ],

];
