<?php

namespace App\Services;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;

class ProviderProfileService
{
    public function getProfile()
    {
        return Auth::user()->load('cities', 'nationality', 'category');
    }

    public function updateProfile(array $data)
    {
        /** @var \App\Models\ServiceProvider $provider */
        $provider = Auth::user();

        if (isset($data['logo'])) {
            if ($provider->logo) {
                Storage::disk('public')->delete($provider->logo);
            }
            $data['logo'] = $data['logo']->store('logos', 'public');
        }

        $provider->update($data);
        $provider->load(['cities', 'nationality', 'category']);
        return $provider;
    }

    public function updateBankDetails(array $data)
    {
        /** @var \App\Models\ServiceProvider $provider */
        $provider = Auth::user();
        $provider->update($data);
        $provider->load(['cities', 'nationality', 'category']);
        return $provider;
    }

    public function changePassword(array $data): bool
    {
        /** @var \App\Models\ServiceProvider $provider */
        $provider = Auth::user();

        if (isset($data['current_password']) && !Hash::check($data['current_password'], $provider->password)) {
            return false;
        }

        $provider->password = Hash::make($data['new_password']);
        $provider->save();

        return true;
    }

    public function deleteProfile()
    {
        /** @var \App\Models\ServiceProvider $provider */
        $provider = Auth::user();

        $provider->delete();
    }
}
