<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class City extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name_en',
        'name_ar',
        'is_active',
    ];

    public function serviceProviders()
    {
        return $this->belongsToMany(ServiceProvider::class, 'city_service_provider');
    }

    public function products()
    {
        return $this->belongsToMany(Product::class, 'city_product');
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', 1);
    }
}
