<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $locale = app()->getLocale();

        return [
            'id' => $this->id,
            'name' => $this->{'name_' . $locale},
            'description' => $this->{'description_' . $locale},
            'icon' => $this->url($this->icon),
            'image' => $this->url($this->image),
        ];
    }

    public function url($path)
    {
        if (!$path) {
            return null;
        }

        if ($path && str_starts_with($path, 'http')) {
            return $path;
        }

        return Storage::url($path);
    }
}