<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckIsProvider
{
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check() && Auth::user() instanceof \App\Models\ServiceProvider) {
            return $next($request);
        }

        return response()->json(['message' => __('messages.inactive_account')], 401);
    }
}
