<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    public function showDeleteForm()
    {
        return view('users.delete');
    }

    public function destroy(Request $request)
    {
        $request->validate([
            'login' => 'required',
            'password' => 'required|confirmed',
        ]);

        $login = $request->input('login');
        $user = User::where('email', $login)->orWhere('phone', $login)->first();

        if (!$user || !Hash::check($request->password, $user->password)) {
            return back()->with('error', __('messages.invalid_credentials'));
        }

        $user->delete();

        return back()->with('success', __('messages.account_deleted_successfully'));
    }
}
