<?php

namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Traits\ApiResponse;
use App\Http\Resources\PageResource;
use App\Models\Page;

class PageController extends Controller
{
    use ApiResponse;
    public function show($slug)
    {
        $page = Page::where('slug', $slug)->firstOrFail();
        return $this->successResponse(new PageResource($page), __('messages.page_retrieved_successfully'));
    }
}
