<?php

namespace App\Filament\Resources\BookingItemResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use App\Models\Admin;
use App\Models\User;
use App\Models\ServiceProvider;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Str;
use function Pest\Laravel\instance;

class ActivitiesRelationManager extends RelationManager
{
    protected static string $relationship = 'activities';

    protected static ?string $recordTitleAttribute = 'description';

    public static function getTitle(Model $ownerRecord, string $pageClass): string
    {
        return __('History');
    }

    public function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc')
            ->columns([
                Tables\Columns\TextColumn::make('causer')
                    ->label(__('Causer'))
                    ->url(function ($record) {
                        if ($record->causer_type === User::class) {
                            return \App\Filament\Resources\UserResource::getUrl('view', ["record" => $record->causer_id]);
                        } elseif ($record->causer_type === ServiceProvider::class) {
                            return \App\Filament\Resources\ServiceProviderResource::getUrl('edit', ["record" => $record->causer_id]);
                        } elseif ($record->causer_type === Admin::class) {
                            return \App\Filament\Resources\AdminResource::getUrl('view', ["record" => $record->causer_id]);
                        }
                        return null;
                    })
                    ->state(fn($record) =>  $record->causer?->full_name ?? $record->causer?->name)
                    ->openUrlInNewTab(),
                Tables\Columns\TextColumn::make('event')
                    ->label(__('Event'))
                    ->formatStateUsing(fn(string $state): string => __($state)),
                // Tables\Columns\TextColumn::make('description')
                // ->label(__('Description')),
                Tables\Columns\TextColumn::make('properties')
                    ->label(__('Changes'))
                    ->bulleted()
                    ->state(function ($record) {
                        $changes = [];
                        $state = $record->properties;
                        if (isset($state['attributes'])) {
                            foreach ($state['attributes'] as $key => $value) {

                                $oldValue = isset($state['old'][$key]) ? $state['old'][$key] : null;
                                if (isset($oldValue) && $oldValue != $value) {
                                    $changes[] = sprintf("%s: %s -> %s", __($key), __($oldValue), __($value));
                                }
                            }
                        }
                        return $changes;
                    }),
                Tables\Columns\TextColumn::make('created_at')
                    ->label(__('Created At'))
                    ->dateTime('Y-m-d h:m:s A'),
            ])
            ->filters([
                //
            ])
            ->headerActions([])
            ->actions([])
            ->bulkActions([]);
    }
}
