<?php

namespace App\Enums;

enum BookingStatus: string
{
    case PENDING = 'pending';
    case PAID = 'paid';
        // case CONFIRMED = 'confirmed';
        // case COMPLETED = 'completed';
    case CANCELED = 'canceled';

    public static function getValues(): array
    {
        return array_column(self::cases(), 'value');
    }

    public static function fromValue(string $value): ?self
    {
        return self::from($value);
    }

    public function label(): string
    {
        return match ($this) {
            self::PENDING => __('Pending'),
            self::PAID => __('PAID'),
            // self::CONFIRMED => __('Confirmed'),
            // self::COMPLETED => __('Completed'),
            self::CANCELED => __('Canceled'),
        };
    }

    public static function options(): array
    {
        return array_combine(
            array_map(fn($case) => $case->value, self::cases()),
            array_map(fn($case) => $case->label(), self::cases())
        );
    }
}
